ALTER TABLE DNS.AUTHENTICATION_LEVEL
 DROP PRIMARY KEY CASCADE;

DROP TABLE DNS.AUTHENTICATION_LEVEL CASCADE CONSTRAINTS;

CREATE TABLE DNS.AUTHENTICATION_LEVEL
(
  CODE                     VARCHAR2(10 BYTE)    NOT NULL,
  NAME                     VARCHAR2(30 BYTE)    NOT NULL,
  DESCRIPTION              VARCHAR2(250 BYTE)   NOT NULL,
  AUTHENTICATION_LEVEL_ID  NUMBER(20)           NOT NULL,
  RECORD_CREATED_BY        VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_MODIFIED_DATE     DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER(10)           NOT NULL
)
TABLESPACE S_DNS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE DNS.AUTHENTICATION_LEVEL IS 'Lookup table containing Authentication Level codes';

COMMENT ON COLUMN DNS.AUTHENTICATION_LEVEL.AUTHENTICATION_LEVEL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN DNS.AUTHENTICATION_LEVEL.RECORD_CREATED_BY IS 'Account or user ID that created the record';

COMMENT ON COLUMN DNS.AUTHENTICATION_LEVEL.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN DNS.AUTHENTICATION_LEVEL.RECORD_MODIFIED_BY IS 'Account or user ID for this modification to the record';

COMMENT ON COLUMN DNS.AUTHENTICATION_LEVEL.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN DNS.AUTHENTICATION_LEVEL.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';



CREATE UNIQUE INDEX DNS.ATHLVLCOD_UK ON DNS.AUTHENTICATION_LEVEL
(CODE)
LOGGING
TABLESPACE S_DNS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX DNS.ATHLVLNAM_UK ON DNS.AUTHENTICATION_LEVEL
(NAME)
LOGGING
TABLESPACE S_DNS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX DNS.ATHLVL_PK ON DNS.AUTHENTICATION_LEVEL
(AUTHENTICATION_LEVEL_ID)
LOGGING
TABLESPACE S_DNS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER DNS.AUTHENTICATION_LEVEL_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON DNS.AUTHENTICATION_LEVEL
  REFERENCING OLD AS OLD NEW AS NEW
  for each row
declare
   	mDML char(1);
begin
  if DELETING then
	INSERT INTO AUTHENTICATION_LEVEL_H (
      AUTHENTICATION_LVL_H_ID,
      AUTHENTICATION_LEVEL_ID,
      CODE,
      NAME,
      DESCRIPTION,
      RECORD_CREATED_BY,
      RECORD_CREATED_DATE,
      RECORD_MODIFIED_BY,
      RECORD_MODIFIED_DATE,
      RECORD_MODIFIED_COUNT,
      TRANSACTION_TYPE_CODE,
      HISTORY_CREATED_DATE )
    VALUES (
      AUTHENTICATION_LEVEL_H_S.nextval
     ,:OLD.AUTHENTICATION_LEVEL_ID,
      :OLD.CODE,
      :OLD.NAME,
      :OLD.DESCRIPTION,
      :OLD.RECORD_CREATED_BY,
      :OLD.RECORD_CREATED_DATE,
      :OLD.RECORD_MODIFIED_BY,
      :OLD.RECORD_MODIFIED_DATE,
      :OLD.RECORD_MODIFIED_COUNT,
      'D',
      SYSDATE );
    else
	if UPDATING then
		mDML := 'U';
	else
		mDML := 'I';
	end if;

	INSERT INTO AUTHENTICATION_LEVEL_H (
      AUTHENTICATION_LVL_H_ID,
      AUTHENTICATION_LEVEL_ID,
      CODE,
      NAME,
      DESCRIPTION,
      RECORD_CREATED_BY,
      RECORD_CREATED_DATE,
      RECORD_MODIFIED_BY,
      RECORD_MODIFIED_DATE,
      RECORD_MODIFIED_COUNT,
      TRANSACTION_TYPE_CODE,
      HISTORY_CREATED_DATE )
    VALUES (
      AUTHENTICATION_LEVEL_H_S.nextval,
      :NEW.AUTHENTICATION_LEVEL_ID,
      :NEW.CODE,
      :NEW.NAME,
      :NEW.DESCRIPTION,
      :NEW.RECORD_CREATED_BY,
      :NEW.RECORD_CREATED_DATE,
      :NEW.RECORD_MODIFIED_BY,
      :NEW.RECORD_MODIFIED_DATE,
      :NEW.RECORD_MODIFIED_COUNT,
      mDML,
      SYSDATE );
  end if;

end AUTHENTICATION_LEVEL_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM AUTHENTICATION_LEVEL FOR DNS.AUTHENTICATION_LEVEL;


ALTER TABLE DNS.AUTHENTICATION_LEVEL ADD (
  CONSTRAINT ATHLVL_PK
  PRIMARY KEY
  (AUTHENTICATION_LEVEL_ID)
  USING INDEX DNS.ATHLVL_PK
  ENABLE VALIDATE,
  CONSTRAINT ATHLVLCOD_UK
  UNIQUE (CODE)
  USING INDEX DNS.ATHLVLCOD_UK
  ENABLE VALIDATE,
  CONSTRAINT ATHLVLNAM_UK
  UNIQUE (NAME)
  USING INDEX DNS.ATHLVLNAM_UK
  ENABLE VALIDATE);

GRANT SELECT ON DNS.AUTHENTICATION_LEVEL TO DNS_R;

GRANT INSERT, SELECT, UPDATE ON DNS.AUTHENTICATION_LEVEL TO DNS_RW;
ALTER TABLE DNS.AUTHENTICATION_LEVEL_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE DNS.AUTHENTICATION_LEVEL_H CASCADE CONSTRAINTS;

CREATE TABLE DNS.AUTHENTICATION_LEVEL_H
(
  CODE                     VARCHAR2(10 BYTE)    NOT NULL,
  NAME                     VARCHAR2(30 BYTE)    NOT NULL,
  DESCRIPTION              VARCHAR2(250 BYTE)   NOT NULL,
  AUTHENTICATION_LEVEL_ID  NUMBER(20)           NOT NULL,
  RECORD_CREATED_BY        VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_MODIFIED_DATE     DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER(10)           NOT NULL,
  HISTORY_CREATED_DATE     DATE                 NOT NULL,
  TRANSACTION_TYPE_CODE    VARCHAR2(1 BYTE)     NOT NULL,
  AUTHENTICATION_LVL_H_ID  NUMBER(20)           NOT NULL
)
TABLESPACE S_DNS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE DNS.AUTHENTICATION_LEVEL_H IS 'Lookup table containing Authentication Level codes';

COMMENT ON COLUMN DNS.AUTHENTICATION_LEVEL_H.AUTHENTICATION_LEVEL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN DNS.AUTHENTICATION_LEVEL_H.RECORD_CREATED_BY IS 'Account or user ID that created the record';

COMMENT ON COLUMN DNS.AUTHENTICATION_LEVEL_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN DNS.AUTHENTICATION_LEVEL_H.RECORD_MODIFIED_BY IS 'Account or user ID for this modification to the record';

COMMENT ON COLUMN DNS.AUTHENTICATION_LEVEL_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN DNS.AUTHENTICATION_LEVEL_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN DNS.AUTHENTICATION_LEVEL_H.HISTORY_CREATED_DATE IS 'Date history record created.';

COMMENT ON COLUMN DNS.AUTHENTICATION_LEVEL_H.TRANSACTION_TYPE_CODE IS 'Whether this row was written because of a Create, Update, or Delete.';

COMMENT ON COLUMN DNS.AUTHENTICATION_LEVEL_H.AUTHENTICATION_LVL_H_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';



CREATE UNIQUE INDEX DNS.ATHLVL_H_PK ON DNS.AUTHENTICATION_LEVEL_H
(AUTHENTICATION_LVL_H_ID)
LOGGING
TABLESPACE S_DNS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE PUBLIC SYNONYM AUTHENTICATION_LEVEL_H FOR DNS.AUTHENTICATION_LEVEL_H;


ALTER TABLE DNS.AUTHENTICATION_LEVEL_H ADD (
  CONSTRAINT ATHLVL_H_PK
  PRIMARY KEY
  (AUTHENTICATION_LVL_H_ID)
  USING INDEX DNS.ATHLVL_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON DNS.AUTHENTICATION_LEVEL_H TO DNS_R;

GRANT INSERT, SELECT, UPDATE ON DNS.AUTHENTICATION_LEVEL_H TO DNS_RW;
ALTER TABLE DNS.ENROLLMENT_FORM_TYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE DNS.ENROLLMENT_FORM_TYPE CASCADE CONSTRAINTS;

CREATE TABLE DNS.ENROLLMENT_FORM_TYPE
(
  ENROLLMENT_FORM_TYPE_ID  NUMBER(20)           NOT NULL,
  CODE                     VARCHAR2(10 BYTE)    NOT NULL,
  NAME                     VARCHAR2(30 BYTE)    NOT NULL,
  DESCRIPTION              VARCHAR2(250 BYTE)   NOT NULL,
  RECORD_CREATED_BY        VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_MODIFIED_DATE     DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER(10)           NOT NULL
)
TABLESPACE S_DNS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE DNS.ENROLLMENT_FORM_TYPE IS 'Lookup table containing Form Type codes';

COMMENT ON COLUMN DNS.ENROLLMENT_FORM_TYPE.ENROLLMENT_FORM_TYPE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN DNS.ENROLLMENT_FORM_TYPE.RECORD_CREATED_BY IS 'Account or user ID that created the record';

COMMENT ON COLUMN DNS.ENROLLMENT_FORM_TYPE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN DNS.ENROLLMENT_FORM_TYPE.RECORD_MODIFIED_BY IS 'Account or user ID for this modification to the record';

COMMENT ON COLUMN DNS.ENROLLMENT_FORM_TYPE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN DNS.ENROLLMENT_FORM_TYPE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';



CREATE UNIQUE INDEX DNS.ENRFRMTYPCOD_UK ON DNS.ENROLLMENT_FORM_TYPE
(CODE)
LOGGING
TABLESPACE S_DNS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX DNS.ENRFRMTYPNAM_UK ON DNS.ENROLLMENT_FORM_TYPE
(NAME)
LOGGING
TABLESPACE S_DNS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX DNS.ENRFRMTYP_PK ON DNS.ENROLLMENT_FORM_TYPE
(ENROLLMENT_FORM_TYPE_ID)
LOGGING
TABLESPACE S_DNS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER DNS.ENROLLMENT_FORM_TYPE_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON DNS.ENROLLMENT_FORM_TYPE
  REFERENCING OLD AS OLD NEW AS NEW
  for each row
declare
   	mDML char(1);
begin
  if DELETING then
	INSERT INTO ENROLLMENT_FORM_TYPE_H (
      ENROLLMENT_FORM_TYP_H_ID,
      ENROLLMENT_FORM_TYPE_ID,
      CODE,
      NAME,
      DESCRIPTION,
      RECORD_CREATED_BY,
      RECORD_CREATED_DATE,
      RECORD_MODIFIED_BY,
      RECORD_MODIFIED_DATE,
      RECORD_MODIFIED_COUNT,
      TRANSACTION_TYPE_CODE,
      HISTORY_CREATED_DATE )
    VALUES (
      ENROLLMENT_FORM_TYPE_H_S.nextval,
      :OLD.ENROLLMENT_FORM_TYPE_ID,
      :OLD.CODE,
      :OLD.NAME,
      :OLD.DESCRIPTION,
      :OLD.RECORD_CREATED_BY,
      :OLD.RECORD_CREATED_DATE,
      :OLD.RECORD_MODIFIED_BY,
      :OLD.RECORD_MODIFIED_DATE,
      :OLD.RECORD_MODIFIED_COUNT,
      'D',
      SYSDATE );
    else
	if UPDATING then
		mDML := 'U';
	else
		mDML := 'I';
	end if;

	INSERT INTO ENROLLMENT_FORM_TYPE_H (
      ENROLLMENT_FORM_TYP_H_ID,
      ENROLLMENT_FORM_TYPE_ID,
      CODE,
      NAME,
      DESCRIPTION,
      RECORD_CREATED_BY,
      RECORD_CREATED_DATE,
      RECORD_MODIFIED_BY,
      RECORD_MODIFIED_DATE,
      RECORD_MODIFIED_COUNT,
      TRANSACTION_TYPE_CODE,
      HISTORY_CREATED_DATE )
    VALUES (
      ENROLLMENT_FORM_TYPE_H_S.nextval,
      :NEW.ENROLLMENT_FORM_TYPE_ID,
      :NEW.CODE,
      :NEW.NAME,
      :NEW.DESCRIPTION,
      :NEW.RECORD_CREATED_BY,
      :NEW.RECORD_CREATED_DATE,
      :NEW.RECORD_MODIFIED_BY,
      :NEW.RECORD_MODIFIED_DATE,
      :NEW.RECORD_MODIFIED_COUNT,
      mDML,
      SYSDATE );
  end if;

end ENROLLMENT_FORM_TYPE_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM ENROLLMENT_FORM_TYPE FOR DNS.ENROLLMENT_FORM_TYPE;


ALTER TABLE DNS.ENROLLMENT_FORM_TYPE ADD (
  CONSTRAINT ENRFRMTYP_PK
  PRIMARY KEY
  (ENROLLMENT_FORM_TYPE_ID)
  USING INDEX DNS.ENRFRMTYP_PK
  ENABLE VALIDATE,
  CONSTRAINT ENRFRMTYPCOD_UK
  UNIQUE (CODE)
  USING INDEX DNS.ENRFRMTYPCOD_UK
  ENABLE VALIDATE,
  CONSTRAINT ENRFRMTYPNAM_UK
  UNIQUE (NAME)
  USING INDEX DNS.ENRFRMTYPNAM_UK
  ENABLE VALIDATE);

GRANT REFERENCES ON DNS.ENROLLMENT_FORM_TYPE TO ADR;

GRANT SELECT ON DNS.ENROLLMENT_FORM_TYPE TO BIZFLOW_R;

GRANT SELECT ON DNS.ENROLLMENT_FORM_TYPE TO DNS_R;

GRANT INSERT, SELECT, UPDATE ON DNS.ENROLLMENT_FORM_TYPE TO DNS_RW;
ALTER TABLE DNS.ENROLLMENT_FORM_TYPE_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE DNS.ENROLLMENT_FORM_TYPE_H CASCADE CONSTRAINTS;

CREATE TABLE DNS.ENROLLMENT_FORM_TYPE_H
(
  ENROLLMENT_FORM_TYPE_ID   NUMBER(20)          NOT NULL,
  CODE                      VARCHAR2(10 BYTE)   NOT NULL,
  NAME                      VARCHAR2(30 BYTE)   NOT NULL,
  DESCRIPTION               VARCHAR2(250 BYTE)  NOT NULL,
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(10)          NOT NULL,
  HISTORY_CREATED_DATE      DATE                NOT NULL,
  TRANSACTION_TYPE_CODE     VARCHAR2(1 BYTE)    NOT NULL,
  ENROLLMENT_FORM_TYP_H_ID  NUMBER(20)          NOT NULL
)
TABLESPACE S_DNS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE DNS.ENROLLMENT_FORM_TYPE_H IS 'Lookup table containing Form Type codes';

COMMENT ON COLUMN DNS.ENROLLMENT_FORM_TYPE_H.ENROLLMENT_FORM_TYPE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN DNS.ENROLLMENT_FORM_TYPE_H.RECORD_CREATED_BY IS 'Account or user ID that created the record';

COMMENT ON COLUMN DNS.ENROLLMENT_FORM_TYPE_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN DNS.ENROLLMENT_FORM_TYPE_H.RECORD_MODIFIED_BY IS 'Account or user ID for this modification to the record';

COMMENT ON COLUMN DNS.ENROLLMENT_FORM_TYPE_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN DNS.ENROLLMENT_FORM_TYPE_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN DNS.ENROLLMENT_FORM_TYPE_H.HISTORY_CREATED_DATE IS 'Date history record created.';

COMMENT ON COLUMN DNS.ENROLLMENT_FORM_TYPE_H.TRANSACTION_TYPE_CODE IS 'Whether this row was written because of a Create, Update, or Delete.';

COMMENT ON COLUMN DNS.ENROLLMENT_FORM_TYPE_H.ENROLLMENT_FORM_TYP_H_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';



CREATE UNIQUE INDEX DNS.ENRFRMTYP_H_PK ON DNS.ENROLLMENT_FORM_TYPE_H
(ENROLLMENT_FORM_TYP_H_ID)
LOGGING
TABLESPACE S_DNS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE PUBLIC SYNONYM ENROLLMENT_FORM_TYPE_H FOR DNS.ENROLLMENT_FORM_TYPE_H;


ALTER TABLE DNS.ENROLLMENT_FORM_TYPE_H ADD (
  CONSTRAINT ENRFRMTYP_H_PK
  PRIMARY KEY
  (ENROLLMENT_FORM_TYP_H_ID)
  USING INDEX DNS.ENRFRMTYP_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON DNS.ENROLLMENT_FORM_TYPE_H TO BIZFLOW_R;

GRANT SELECT ON DNS.ENROLLMENT_FORM_TYPE_H TO DNS_R;

GRANT INSERT, SELECT, UPDATE ON DNS.ENROLLMENT_FORM_TYPE_H TO DNS_RW;
ALTER TABLE DNS.DNS_ENROLLMENT_APPLICATION
 DROP PRIMARY KEY CASCADE;

DROP TABLE DNS.DNS_ENROLLMENT_APPLICATION CASCADE CONSTRAINTS;

CREATE TABLE DNS.DNS_ENROLLMENT_APPLICATION
(
  DNS_ENROLLMENT_APP_ID         NUMBER(20)      NOT NULL,
  PERSON_ID                     NUMBER(20),
  DNS_ENROLLMENT_APP_STATUS_ID  NUMBER(20)      NOT NULL,
  ENROLLMENT_FORM_TYPE_ID       NUMBER(20)      NOT NULL,
  AUTHENTICATION_LEVEL_ID       NUMBER(20)      NOT NULL,
  STD_GENDER_ID                 NUMBER(20),
  RESPONSE_TIMESTAMP            TIMESTAMP(6),
  ERROR_TEXT                    VARCHAR2(2000 BYTE),
  FULLY_QUALIFIED_ID            VARCHAR2(65 BYTE),
  PREFERRED_FACILITY_ID         NUMBER(20),
  REQUEST_RECEIVED_TIMESTAMP    TIMESTAMP(6),
  RECORD_CREATED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE           DATE            NOT NULL,
  RECORD_MODIFIED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE          DATE            NOT NULL,
  RECORD_MODIFIED_COUNT         NUMBER(10)      NOT NULL,
  APPLICANT_LAST_NAME           VARCHAR2(35 BYTE) NOT NULL,
  APPLICANT_FIRST_NAME          VARCHAR2(25 BYTE),
  APPLICANT_MIDDLE_NAME         VARCHAR2(25 BYTE),
  APPLICANT_DOB                 DATE            NOT NULL,
  APPLICANT_SSN                 VARCHAR2(30 BYTE) NOT NULL,
  VETERAN_IDENTIFIER_TYPE_ID    NUMBER(20),
  BF_PROCESSED                  NUMBER(1)
)
TABLESPACE M_DNS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE DNS.DNS_ENROLLMENT_APPLICATION IS 'The DNS_ENROLLMENT_APPLICATION table contains the DNS enrollment application record containing information about the applicant, the forms submitted, and processing information. Foreign Keys present in table: PERSON_ID STD_ENROLLMENTAPPSTATUS_ID (The status of the form processing) STD_ENROLLMENTFORMTYPE_ID (The form type name of document) STD_AUTHENTICATIONLEVEL_ID (Assurance level of the document) VETERAN_IDENTIFIER_TYPE_ID (The veteran identify type)
On 11/1012 expected 11,500 rows to be added to table each month';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APPLICATION.DNS_ENROLLMENT_APP_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APPLICATION.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APPLICATION.DNS_ENROLLMENT_APP_STATUS_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APPLICATION.ENROLLMENT_FORM_TYPE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APPLICATION.AUTHENTICATION_LEVEL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APPLICATION.STD_GENDER_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APPLICATION.RESPONSE_TIMESTAMP IS 'Timestamp when the DNS response was sent.';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APPLICATION.ERROR_TEXT IS 'Error text message(s) generated during processing of DNS message';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APPLICATION.PREFERRED_FACILITY_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APPLICATION.REQUEST_RECEIVED_TIMESTAMP IS 'Timestamp when the DNS request was received.';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APPLICATION.RECORD_CREATED_BY IS 'Account or user ID that created the record';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APPLICATION.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APPLICATION.RECORD_MODIFIED_BY IS 'Account or user ID for this modification to the record';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APPLICATION.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APPLICATION.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APPLICATION.APPLICANT_DOB IS 'Date of birth of the applicant.';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APPLICATION.APPLICANT_SSN IS 'Social Security Number of the applicant.';



CREATE INDEX DNS.DNSENRAPP_ATHLVL_FK_I ON DNS.DNS_ENROLLMENT_APPLICATION
(AUTHENTICATION_LEVEL_ID)
LOGGING
TABLESPACE M_DNS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE INDEX DNS.DNSENRAPP_ENRFRMTYP_FK_I ON DNS.DNS_ENROLLMENT_APPLICATION
(ENROLLMENT_FORM_TYPE_ID)
LOGGING
TABLESPACE M_DNS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX DNS.DNSENRAPP_PK ON DNS.DNS_ENROLLMENT_APPLICATION
(DNS_ENROLLMENT_APP_ID)
LOGGING
TABLESPACE S_DNS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE INDEX DNS.DNSENRAPP_PRSN_FK_I ON DNS.DNS_ENROLLMENT_APPLICATION
(PERSON_ID)
LOGGING
TABLESPACE M_DNS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE INDEX DNS.DNSENRAPP_VETIDTYP_FK_I ON DNS.DNS_ENROLLMENT_APPLICATION
(VETERAN_IDENTIFIER_TYPE_ID)
LOGGING
TABLESPACE S_VBR_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE INDEX DNS.DNSENRAPP_DNSENRAPPSTA_FK_I ON DNS.DNS_ENROLLMENT_APPLICATION
(DNS_ENROLLMENT_APP_STATUS_ID)
LOGGING
TABLESPACE M_DNS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER DNS.DNS_ENROLL_APP_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON DNS.DNS_ENROLLMENT_APPLICATION
  REFERENCING OLD AS OLD NEW AS NEW
  for each row
declare
    mDML char(1);
begin
  if DELETING then
  INSERT INTO DNS_ENROLLMENT_APPLICATION_H (
      DNS_ENROLLMENT_APP_H_ID,
      DNS_ENROLLMENT_APP_ID,
      PERSON_ID,
      DNS_ENROLLMENT_APP_STATUS_ID,
      ENROLLMENT_FORM_TYPE_ID,
      AUTHENTICATION_LEVEL_ID,
      VETERAN_IDENTIFIER_TYPE_ID,
      APPLICANT_LAST_NAME,
      APPLICANT_FIRST_NAME,
      APPLICANT_MIDDLE_NAME,
      APPLICANT_DOB,
      APPLICANT_SSN,
      STD_GENDER_ID,
      RESPONSE_TIMESTAMP,
      ERROR_TEXT,
      FULLY_QUALIFIED_ID,
      PREFERRED_FACILITY_ID,
      REQUEST_RECEIVED_TIMESTAMP,
      RECORD_CREATED_BY,
      RECORD_CREATED_DATE,
      RECORD_MODIFIED_BY,
      RECORD_MODIFIED_DATE,
      RECORD_MODIFIED_COUNT,
      TRANSACTION_TYPE_CODE,
      HISTORY_CREATED_DATE,
      BF_PROCESSED)
    VALUES (
      DNS_ENROLLMENT_APPLICATION_H_S.nextval,
      :OLD.DNS_ENROLLMENT_APP_ID,
      :OLD.PERSON_ID,
      :OLD.DNS_ENROLLMENT_APP_STATUS_ID,
      :OLD.ENROLLMENT_FORM_TYPE_ID,
      :OLD.AUTHENTICATION_LEVEL_ID,
      :OLD.VETERAN_IDENTIFIER_TYPE_ID,
      :OLD.APPLICANT_LAST_NAME,
      :OLD.APPLICANT_FIRST_NAME,
      :OLD.APPLICANT_MIDDLE_NAME,
      :OLD.APPLICANT_DOB,
      :OLD.APPLICANT_SSN,
      :OLD.STD_GENDER_ID,
      :OLD.RESPONSE_TIMESTAMP,
      :OLD.ERROR_TEXT,
      :OLD.FULLY_QUALIFIED_ID,
      :OLD.PREFERRED_FACILITY_ID,
      :OLD.REQUEST_RECEIVED_TIMESTAMP,
      :OLD.RECORD_CREATED_BY,
      :OLD.RECORD_CREATED_DATE,
      :OLD.RECORD_MODIFIED_BY,
      :OLD.RECORD_MODIFIED_DATE,
      :OLD.RECORD_MODIFIED_COUNT,
      'D',
      SYSDATE,
      :OLD.BF_PROCESSED);
    else
  if UPDATING then
    mDML := 'U';
  else
    mDML := 'I';
  end if;

  INSERT INTO DNS_ENROLLMENT_APPLICATION_H (
      DNS_ENROLLMENT_APP_H_ID,
      DNS_ENROLLMENT_APP_ID,
      PERSON_ID,
      DNS_ENROLLMENT_APP_STATUS_ID,
      ENROLLMENT_FORM_TYPE_ID,
      AUTHENTICATION_LEVEL_ID,
      VETERAN_IDENTIFIER_TYPE_ID,
      APPLICANT_LAST_NAME,
      APPLICANT_FIRST_NAME,
      APPLICANT_MIDDLE_NAME,
      APPLICANT_DOB,
      APPLICANT_SSN,
      STD_GENDER_ID,
      RESPONSE_TIMESTAMP,
      ERROR_TEXT,
      FULLY_QUALIFIED_ID,
      PREFERRED_FACILITY_ID,
      REQUEST_RECEIVED_TIMESTAMP,
      RECORD_CREATED_BY,
      RECORD_CREATED_DATE,
      RECORD_MODIFIED_BY,
      RECORD_MODIFIED_DATE,
      RECORD_MODIFIED_COUNT,
      TRANSACTION_TYPE_CODE,
      HISTORY_CREATED_DATE,
      BF_PROCESSED)
    VALUES (
      DNS_ENROLLMENT_APPLICATION_H_S.nextval,
      :NEW.DNS_ENROLLMENT_APP_ID,
      :NEW.PERSON_ID,
      :NEW.DNS_ENROLLMENT_APP_STATUS_ID,
      :NEW.ENROLLMENT_FORM_TYPE_ID,
      :NEW.AUTHENTICATION_LEVEL_ID,
      :NEW.VETERAN_IDENTIFIER_TYPE_ID,
      :NEW.APPLICANT_LAST_NAME,
      :NEW.APPLICANT_FIRST_NAME,
      :NEW.APPLICANT_MIDDLE_NAME,
      :NEW.APPLICANT_DOB,
      :NEW.APPLICANT_SSN,
      :NEW.STD_GENDER_ID,
      :NEW.RESPONSE_TIMESTAMP,
      :NEW.ERROR_TEXT,
      :NEW.FULLY_QUALIFIED_ID,
      :NEW.PREFERRED_FACILITY_ID,
      :NEW.REQUEST_RECEIVED_TIMESTAMP,
      :NEW.RECORD_CREATED_BY,
      :NEW.RECORD_CREATED_DATE,
      :NEW.RECORD_MODIFIED_BY,
      :NEW.RECORD_MODIFIED_DATE,
      :NEW.RECORD_MODIFIED_COUNT,
      mDML,
      SYSDATE,
      :NEW.BF_PROCESSED);
  end if;

end DNS_ENROLL_APP_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM DNS_ENROLLMENT_APPLICATION FOR DNS.DNS_ENROLLMENT_APPLICATION;


ALTER TABLE DNS.DNS_ENROLLMENT_APPLICATION ADD (
  CONSTRAINT DNSENRAPP_PK
  PRIMARY KEY
  (DNS_ENROLLMENT_APP_ID)
  USING INDEX DNS.DNSENRAPP_PK
  ENABLE VALIDATE);

ALTER TABLE DNS.DNS_ENROLLMENT_APPLICATION ADD (
  CONSTRAINT DNSENRAPP_ATHLVL_FK 
  FOREIGN KEY (AUTHENTICATION_LEVEL_ID) 
  REFERENCES DNS.AUTHENTICATION_LEVEL (AUTHENTICATION_LEVEL_ID)
  ENABLE VALIDATE,
  CONSTRAINT DNSENRAPP_ENRFRMTYP_FK 
  FOREIGN KEY (ENROLLMENT_FORM_TYPE_ID) 
  REFERENCES DNS.ENROLLMENT_FORM_TYPE (ENROLLMENT_FORM_TYPE_ID)
  ENABLE VALIDATE,
  CONSTRAINT DNSENRAPP_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ON DELETE SET NULL
  ENABLE VALIDATE,
  CONSTRAINT DNSENRAPP_VETIDTYP_FK 
  FOREIGN KEY (VETERAN_IDENTIFIER_TYPE_ID) 
  REFERENCES VBR.VETERAN_IDENTIFIER_TYPE (VETERAN_IDENTIFIER_TYPE_ID)
  ENABLE VALIDATE,
  CONSTRAINT DNSENRAPP_DNSENRAPPSTA_FK 
  FOREIGN KEY (DNS_ENROLLMENT_APP_STATUS_ID) 
  REFERENCES DNS.DNS_ENROLLMENT_APP_STATUS (DNS_ENROLLMENT_APP_STATUS_ID)
  ENABLE VALIDATE);

GRANT INSERT, SELECT, UPDATE ON DNS.DNS_ENROLLMENT_APPLICATION TO BIZFLOW_RW;

GRANT REFERENCES ON DNS.DNS_ENROLLMENT_APPLICATION TO LOBR;

GRANT SELECT ON DNS.DNS_ENROLLMENT_APPLICATION TO DNS_R;

GRANT INSERT, SELECT, UPDATE ON DNS.DNS_ENROLLMENT_APPLICATION TO DNS_RW;
ALTER TABLE DNS.DNS_ENROLLMENT_APPLICATION_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE DNS.DNS_ENROLLMENT_APPLICATION_H CASCADE CONSTRAINTS;

CREATE TABLE DNS.DNS_ENROLLMENT_APPLICATION_H
(
  DNS_ENROLLMENT_APP_ID         NUMBER(20)      NOT NULL,
  PERSON_ID                     NUMBER(20),
  DNS_ENROLLMENT_APP_STATUS_ID  NUMBER(20)      NOT NULL,
  ENROLLMENT_FORM_TYPE_ID       NUMBER(20)      NOT NULL,
  AUTHENTICATION_LEVEL_ID       NUMBER(20)      NOT NULL,
  VETERAN_IDENTIFIER_TYPE_ID    NUMBER(20),
  STD_GENDER_ID                 NUMBER(20),
  RESPONSE_TIMESTAMP            TIMESTAMP(6),
  ERROR_TEXT                    VARCHAR2(2000 BYTE),
  FULLY_QUALIFIED_ID            VARCHAR2(65 BYTE),
  PREFERRED_FACILITY_ID         NUMBER(20),
  REQUEST_RECEIVED_TIMESTAMP    TIMESTAMP(6),
  RECORD_CREATED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE           DATE            NOT NULL,
  RECORD_MODIFIED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE          DATE            NOT NULL,
  RECORD_MODIFIED_COUNT         NUMBER(10)      NOT NULL,
  APPLICANT_LAST_NAME           VARCHAR2(35 BYTE) NOT NULL,
  APPLICANT_FIRST_NAME          VARCHAR2(25 BYTE),
  APPLICANT_MIDDLE_NAME         VARCHAR2(25 BYTE),
  APPLICANT_DOB                 DATE            NOT NULL,
  APPLICANT_SSN                 VARCHAR2(30 BYTE) NOT NULL,
  HISTORY_CREATED_DATE          DATE            NOT NULL,
  TRANSACTION_TYPE_CODE         VARCHAR2(1 BYTE) NOT NULL,
  DNS_ENROLLMENT_APP_H_ID       NUMBER(20)      NOT NULL,
  BF_PROCESSED                  NUMBER(1)
)
TABLESPACE M_DNS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE DNS.DNS_ENROLLMENT_APPLICATION_H IS 'History table for the DNS_ENROLLMENT APP table.  Contains all changes made to the DNS_ENROLLMENT APP table.  Records inserted into the table via a trigger.
On 11/1012 expected 11,500 rows to be added to table each month';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APPLICATION_H.DNS_ENROLLMENT_APP_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APPLICATION_H.DNS_ENROLLMENT_APP_STATUS_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APPLICATION_H.ENROLLMENT_FORM_TYPE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APPLICATION_H.AUTHENTICATION_LEVEL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APPLICATION_H.VETERAN_IDENTIFIER_TYPE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APPLICATION_H.STD_GENDER_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APPLICATION_H.RESPONSE_TIMESTAMP IS 'Timestamp when the DNS response was sent.';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APPLICATION_H.ERROR_TEXT IS 'Error text message(s) generated during processing of DNS message';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APPLICATION_H.PREFERRED_FACILITY_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APPLICATION_H.REQUEST_RECEIVED_TIMESTAMP IS 'Timestamp when the DNS request was received.';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APPLICATION_H.RECORD_CREATED_BY IS 'Account or user ID that created the record';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APPLICATION_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APPLICATION_H.RECORD_MODIFIED_BY IS 'Account or user ID for this modification to the record';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APPLICATION_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APPLICATION_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APPLICATION_H.APPLICANT_DOB IS 'Date of birth of the applicant.';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APPLICATION_H.APPLICANT_SSN IS 'Social Security Number of the applicant.';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APPLICATION_H.HISTORY_CREATED_DATE IS 'Date history record created.';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APPLICATION_H.TRANSACTION_TYPE_CODE IS 'Whether this row was written because of a Create, Update, or Delete.';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APPLICATION_H.DNS_ENROLLMENT_APP_H_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';



CREATE UNIQUE INDEX DNS.DNSENRAPP_H_PK ON DNS.DNS_ENROLLMENT_APPLICATION_H
(DNS_ENROLLMENT_APP_H_ID)
LOGGING
TABLESPACE S_DNS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE PUBLIC SYNONYM DNS_ENROLLMENT_APPLICATION_H FOR DNS.DNS_ENROLLMENT_APPLICATION_H;


ALTER TABLE DNS.DNS_ENROLLMENT_APPLICATION_H ADD (
  CONSTRAINT DNSENRAPP_H_PK
  PRIMARY KEY
  (DNS_ENROLLMENT_APP_H_ID)
  USING INDEX DNS.DNSENRAPP_H_PK
  ENABLE VALIDATE);

GRANT INSERT, SELECT ON DNS.DNS_ENROLLMENT_APPLICATION_H TO BIZFLOW_RW;

GRANT SELECT ON DNS.DNS_ENROLLMENT_APPLICATION_H TO DNS_R;

GRANT INSERT, SELECT, UPDATE ON DNS.DNS_ENROLLMENT_APPLICATION_H TO DNS_RW;
ALTER TABLE DNS.DNS_ENROLLMENT_APP_DATA
 DROP PRIMARY KEY CASCADE;

DROP TABLE DNS.DNS_ENROLLMENT_APP_DATA CASCADE CONSTRAINTS;

CREATE TABLE DNS.DNS_ENROLLMENT_APP_DATA
(
  DNS_ENROLLMENT_APP_DATA_ID  NUMBER(20)        NOT NULL,
  APPLICATION_DATA            CLOB              NOT NULL,
  DNS_ENROLLMENT_APP_ID       NUMBER(20)        NOT NULL,
  RECORD_CREATED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE         DATE              NOT NULL,
  RECORD_MODIFIED_BY          VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE        DATE              NOT NULL,
  RECORD_MODIFIED_COUNT       NUMBER(10)        NOT NULL
)
LOB (APPLICATION_DATA) STORE AS SECUREFILE (
  TABLESPACE  L_DNS_DATA_01
  ENABLE      STORAGE IN ROW
  CHUNK       8192
  DEDUPLICATE
  NOCACHE
  LOGGING
      STORAGE    (
                  INITIAL          128M
                  NEXT             128M
                  MINEXTENTS       1
                  MAXEXTENTS       UNLIMITED
                  PCTINCREASE      0
                  BUFFER_POOL      DEFAULT
                  FLASH_CACHE      DEFAULT
                  CELL_FLASH_CACHE DEFAULT
                 ))
TABLESPACE M_DNS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE DNS.DNS_ENROLLMENT_APP_DATA IS 'The DNS_ENROLLMENT_APP_DATA table contain the DNS data in CLOB format that was sent to be processed.
On 11/1012 expected 11,500 rows to be added to table each month The size of data in the application_data field will be similar to the size of data in the adr aap.application_in_process_id.application_context_xml field.';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APP_DATA.DNS_ENROLLMENT_APP_DATA_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APP_DATA.DNS_ENROLLMENT_APP_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APP_DATA.RECORD_CREATED_BY IS 'Account or user ID that created the record';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APP_DATA.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APP_DATA.RECORD_MODIFIED_BY IS 'Account or user ID for this modification to the record';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APP_DATA.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APP_DATA.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';



CREATE UNIQUE INDEX DNS.DNSENRAPPDATA_PK ON DNS.DNS_ENROLLMENT_APP_DATA
(DNS_ENROLLMENT_APP_DATA_ID)
LOGGING
TABLESPACE S_DNS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE INDEX DNS.DNSENRAPPDAT_DNSENRAPP_FK_I ON DNS.DNS_ENROLLMENT_APP_DATA
(DNS_ENROLLMENT_APP_ID)
LOGGING
TABLESPACE M_DNS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE PUBLIC SYNONYM DNS_ENROLLMENT_APP_DATA FOR DNS.DNS_ENROLLMENT_APP_DATA;


ALTER TABLE DNS.DNS_ENROLLMENT_APP_DATA ADD (
  CONSTRAINT DNSENRAPPDATA_PK
  PRIMARY KEY
  (DNS_ENROLLMENT_APP_DATA_ID)
  USING INDEX DNS.DNSENRAPPDATA_PK
  ENABLE VALIDATE);

ALTER TABLE DNS.DNS_ENROLLMENT_APP_DATA ADD (
  CONSTRAINT DNSENRAPPDAT_DNSENRAPP_FK 
  FOREIGN KEY (DNS_ENROLLMENT_APP_ID) 
  REFERENCES DNS.DNS_ENROLLMENT_APPLICATION (DNS_ENROLLMENT_APP_ID)
  ENABLE VALIDATE);

GRANT SELECT ON DNS.DNS_ENROLLMENT_APP_DATA TO DNS_R;

GRANT INSERT, SELECT, UPDATE ON DNS.DNS_ENROLLMENT_APP_DATA TO DNS_RW;
ALTER TABLE DNS.DNS_ENROLLMENT_APP_STATUS
 DROP PRIMARY KEY CASCADE;

DROP TABLE DNS.DNS_ENROLLMENT_APP_STATUS CASCADE CONSTRAINTS;

CREATE TABLE DNS.DNS_ENROLLMENT_APP_STATUS
(
  DNS_ENROLLMENT_APP_STATUS_ID  NUMBER(20)      NOT NULL,
  DESCRIPTION                   VARCHAR2(250 BYTE) NOT NULL,
  NAME                          VARCHAR2(30 BYTE) NOT NULL,
  CODE                          VARCHAR2(10 BYTE) NOT NULL,
  RECORD_CREATED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE           DATE            NOT NULL,
  RECORD_MODIFIED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE          DATE            NOT NULL,
  RECORD_MODIFIED_COUNT         NUMBER(10)      NOT NULL
)
TABLESPACE S_DNS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE DNS.DNS_ENROLLMENT_APP_STATUS IS 'Lookup table containing DNS Application Status codes.
This is a DNS owned table and different from the ADRREF.STD_ENROLL_APPLICATION_STATUS.';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APP_STATUS.DNS_ENROLLMENT_APP_STATUS_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APP_STATUS.RECORD_CREATED_BY IS 'Account or user ID that created the record';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APP_STATUS.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APP_STATUS.RECORD_MODIFIED_BY IS 'Account or user ID for this modification to the record';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APP_STATUS.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APP_STATUS.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';



CREATE UNIQUE INDEX DNS.DNSENRAPPSTATCOD_UK ON DNS.DNS_ENROLLMENT_APP_STATUS
(CODE)
LOGGING
TABLESPACE S_DNS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX DNS.DNSENRAPPSTATNAM_UK ON DNS.DNS_ENROLLMENT_APP_STATUS
(NAME)
LOGGING
TABLESPACE S_DNS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX DNS.DNSENRAPPSTAT_PK ON DNS.DNS_ENROLLMENT_APP_STATUS
(DNS_ENROLLMENT_APP_STATUS_ID)
LOGGING
TABLESPACE S_DNS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE TRIGGER DNS.DNS_ENROLLMENT_APP_STATUS_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON DNS.DNS_ENROLLMENT_APP_STATUS
  REFERENCING OLD AS OLD NEW AS NEW
  for each row
declare
   	mDML char(1);
begin
  if DELETING then
	INSERT INTO DNS_ENROLLMENT_APP_STATUS_H (
      DNS_ENROLLMENT_APP_STAT_H_ID,
      DNS_ENROLLMENT_APP_STATUS_ID,
      CODE,
      NAME,
      DESCRIPTION,
      RECORD_CREATED_BY,
      RECORD_CREATED_DATE,
      RECORD_MODIFIED_BY,
      RECORD_MODIFIED_DATE,
      RECORD_MODIFIED_COUNT,
      TRANSACTION_TYPE_CODE,
      HISTORY_CREATED_DATE )
    VALUES (
      DNS_ENROLLMENT_APP_STATUS_H_S.nextval,
      :OLD.DNS_ENROLLMENT_APP_STATUS_ID,
      :OLD.CODE,
      :OLD.NAME,
      :OLD.DESCRIPTION,
      :OLD.RECORD_CREATED_BY,
      :OLD.RECORD_CREATED_DATE,
      :OLD.RECORD_MODIFIED_BY,
      :OLD.RECORD_MODIFIED_DATE,
      :OLD.RECORD_MODIFIED_COUNT,
      'D',
      SYSDATE );
    else
	if UPDATING then
		mDML := 'U';
	else
		mDML := 'I';
	end if;

	INSERT INTO DNS_ENROLLMENT_APP_STATUS_H (
      DNS_ENROLLMENT_APP_STAT_H_ID,
      DNS_ENROLLMENT_APP_STATUS_ID,
      CODE,
      NAME,
      DESCRIPTION,
      RECORD_CREATED_BY,
      RECORD_CREATED_DATE,
      RECORD_MODIFIED_BY,
      RECORD_MODIFIED_DATE,
      RECORD_MODIFIED_COUNT,
      TRANSACTION_TYPE_CODE,
      HISTORY_CREATED_DATE )
    VALUES (
      DNS_ENROLLMENT_APP_STATUS_H_S.nextval,
      :NEW.DNS_ENROLLMENT_APP_STATUS_ID,
      :NEW.CODE,
      :NEW.NAME,
      :NEW.DESCRIPTION,
      :NEW.RECORD_CREATED_BY,
      :NEW.RECORD_CREATED_DATE,
      :NEW.RECORD_MODIFIED_BY,
      :NEW.RECORD_MODIFIED_DATE,
      :NEW.RECORD_MODIFIED_COUNT,
      mDML,
      SYSDATE );
  end if;

end DNS_ENROLLMENT_APP_STATUS_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM DNS_ENROLLMENT_APP_STATUS FOR DNS.DNS_ENROLLMENT_APP_STATUS;


ALTER TABLE DNS.DNS_ENROLLMENT_APP_STATUS ADD (
  CONSTRAINT DNSENRAPPSTAT_PK
  PRIMARY KEY
  (DNS_ENROLLMENT_APP_STATUS_ID)
  USING INDEX DNS.DNSENRAPPSTAT_PK
  ENABLE VALIDATE,
  CONSTRAINT DNSENRAPPSTATCOD_UK
  UNIQUE (CODE)
  USING INDEX DNS.DNSENRAPPSTATCOD_UK
  ENABLE VALIDATE,
  CONSTRAINT DNSENRAPPSTATNAM_UK
  UNIQUE (NAME)
  USING INDEX DNS.DNSENRAPPSTATNAM_UK
  ENABLE VALIDATE);

GRANT SELECT ON DNS.DNS_ENROLLMENT_APP_STATUS TO DNS_R;

GRANT INSERT, SELECT, UPDATE ON DNS.DNS_ENROLLMENT_APP_STATUS TO DNS_RW;
ALTER TABLE DNS.DNS_ENROLLMENT_APP_STATUS_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE DNS.DNS_ENROLLMENT_APP_STATUS_H CASCADE CONSTRAINTS;

CREATE TABLE DNS.DNS_ENROLLMENT_APP_STATUS_H
(
  DNS_ENROLLMENT_APP_STATUS_ID  NUMBER(20)      NOT NULL,
  DESCRIPTION                   VARCHAR2(250 BYTE) NOT NULL,
  NAME                          VARCHAR2(30 BYTE) NOT NULL,
  CODE                          VARCHAR2(10 BYTE) NOT NULL,
  RECORD_CREATED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE           DATE            NOT NULL,
  RECORD_MODIFIED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE          DATE            NOT NULL,
  RECORD_MODIFIED_COUNT         NUMBER(10)      NOT NULL,
  HISTORY_CREATED_DATE          DATE            NOT NULL,
  TRANSACTION_TYPE_CODE         VARCHAR2(1 BYTE) NOT NULL,
  DNS_ENROLLMENT_APP_STAT_H_ID  NUMBER(20)      NOT NULL
)
TABLESPACE S_DNS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE DNS.DNS_ENROLLMENT_APP_STATUS_H IS 'Lookup table containing DNS Application Status codes.
This is a DNS owned table and different from the ADRREF.STD_ENROLL_APPLICATION_STATUS.';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APP_STATUS_H.DNS_ENROLLMENT_APP_STATUS_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APP_STATUS_H.RECORD_CREATED_BY IS 'Account or user ID that created the record';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APP_STATUS_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APP_STATUS_H.RECORD_MODIFIED_BY IS 'Account or user ID for this modification to the record';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APP_STATUS_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APP_STATUS_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APP_STATUS_H.HISTORY_CREATED_DATE IS 'Date history record created.';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APP_STATUS_H.TRANSACTION_TYPE_CODE IS 'Whether this row was written because of a Create, Update, or Delete.';

COMMENT ON COLUMN DNS.DNS_ENROLLMENT_APP_STATUS_H.DNS_ENROLLMENT_APP_STAT_H_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';



CREATE UNIQUE INDEX DNS.DNSENRAPPSTAT_H_PK ON DNS.DNS_ENROLLMENT_APP_STATUS_H
(DNS_ENROLLMENT_APP_STAT_H_ID)
LOGGING
TABLESPACE S_DNS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE PUBLIC SYNONYM DNS_ENROLLMENT_APP_STATUS_H FOR DNS.DNS_ENROLLMENT_APP_STATUS_H;


ALTER TABLE DNS.DNS_ENROLLMENT_APP_STATUS_H ADD (
  CONSTRAINT DNSENRAPPSTAT_H_PK
  PRIMARY KEY
  (DNS_ENROLLMENT_APP_STAT_H_ID)
  USING INDEX DNS.DNSENRAPPSTAT_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON DNS.DNS_ENROLLMENT_APP_STATUS_H TO DNS_R;

GRANT INSERT, SELECT, UPDATE ON DNS.DNS_ENROLLMENT_APP_STATUS_H TO DNS_RW;
ALTER TABLE DNS.DNS_RESUBMISSION
 DROP PRIMARY KEY CASCADE;

DROP TABLE DNS.DNS_RESUBMISSION CASCADE CONSTRAINTS;

CREATE TABLE DNS.DNS_RESUBMISSION
(
  DNS_RESUBMISSION_ID       NUMBER(20)          NOT NULL,
  DNS_ENROLLMENT_APP_ID     NUMBER(20)          NOT NULL,
  PENDING_APPLICATION_TEXT  CLOB,
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(10)          NOT NULL
)
LOB (PENDING_APPLICATION_TEXT) STORE AS SECUREFILE (
  TABLESPACE  L_DNS_DATA_01
  ENABLE      STORAGE IN ROW
  CHUNK       8192
  DEDUPLICATE
  NOCACHE
  LOGGING
      STORAGE    (
                  INITIAL          128M
                  NEXT             128M
                  MINEXTENTS       1
                  MAXEXTENTS       UNLIMITED
                  PCTINCREASE      0
                  BUFFER_POOL      DEFAULT
                  FLASH_CACHE      DEFAULT
                  CELL_FLASH_CACHE DEFAULT
                 ))
TABLESPACE M_DNS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE DNS.DNS_RESUBMISSION IS 'While processing the application form submitted by the user, some scenarios require manual intervention by HEC users. In these scenarios, form data in progress is saved to continue processing once the issue has been manually resolved  by the HEC user.';

COMMENT ON COLUMN DNS.DNS_RESUBMISSION.DNS_RESUBMISSION_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN DNS.DNS_RESUBMISSION.DNS_ENROLLMENT_APP_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN DNS.DNS_RESUBMISSION.PENDING_APPLICATION_TEXT IS ' Once the form is successfully processed, we can delete the CLOB in order to avoid unnecessary storage.';

COMMENT ON COLUMN DNS.DNS_RESUBMISSION.RECORD_CREATED_BY IS 'Account or user ID that created the record';

COMMENT ON COLUMN DNS.DNS_RESUBMISSION.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN DNS.DNS_RESUBMISSION.RECORD_MODIFIED_BY IS 'Account or user ID for this modification to the record';

COMMENT ON COLUMN DNS.DNS_RESUBMISSION.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN DNS.DNS_RESUBMISSION.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';



CREATE UNIQUE INDEX DNS.DNSRSB_PK ON DNS.DNS_RESUBMISSION
(DNS_RESUBMISSION_ID)
LOGGING
TABLESPACE L_DNS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE INDEX DNS.DNSRSB_DNSENRAPP_FK_I ON DNS.DNS_RESUBMISSION
(DNS_ENROLLMENT_APP_ID)
LOGGING
TABLESPACE L_DNS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE PUBLIC SYNONYM DNS_RESUBMISSION FOR DNS.DNS_RESUBMISSION;


ALTER TABLE DNS.DNS_RESUBMISSION ADD (
  CONSTRAINT DNSRSB_PK
  PRIMARY KEY
  (DNS_RESUBMISSION_ID)
  USING INDEX DNS.DNSRSB_PK
  ENABLE VALIDATE);

ALTER TABLE DNS.DNS_RESUBMISSION ADD (
  CONSTRAINT DNSRSB_DNSENRAPP_FK 
  FOREIGN KEY (DNS_ENROLLMENT_APP_ID) 
  REFERENCES DNS.DNS_ENROLLMENT_APPLICATION (DNS_ENROLLMENT_APP_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON DNS.DNS_RESUBMISSION TO DNS_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON DNS.DNS_RESUBMISSION TO DNS_RW;
